/************************************************************************
*
* Copyright:
*	Freescale Semiconductor, INC. All Rights Reserved.  
*  You are hereby granted a copyright license to use, modify, and
*  distribute the SOFTWARE so long as this entire notice is
*  retained without alteration in any modified and/or redistributed
*  versions, and that such modified versions are clearly identified
*  as such. No licenses are granted by implication, estoppel or
*  otherwise under any patents or trademarks of Freescale Semiconductor, 
*  Inc. This software is provided on an "AS IS" basis and without warranty.
*
*  To the maximum extent permitted by applicable law, FREESCALE 
*  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING 
*  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
*  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE 
*  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY 
*  ACCOMPANYING WRITTEN MATERIALS.
* 
*  To the maximum extent permitted by applicable law, IN NO EVENT
*  SHALL FREESCALE BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING 
*  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS 
*  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY
*  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.   
* 
*  Freescale assumes no responsibility for the maintenance and support
*  of this software
*************************************************************************
*
*  FILE NAME: iir.h
*
*  PURPOSE: main header file for the eMAC library
*
*  AUTHORS: Anatoly Khaynakov and Andriy Tymkiv
*
*************************************************************************/





#ifndef __IIR_H
#define __IIR_H

#define __EMAC				// Comment it if you want to test the DSP functions 
							//   using the MAC computation

/* Fractional data types for portability */
typedef short int            Frac16;
typedef long int             Frac32;

#include "mcf5282.h"
#include "16bits\iir16.h"
#include "32bits\iir32.h"
//#include "Memory\memalloc.h"

typedef void (*tPointerFcn)(void); /* pointer to void function */

//Macros to convert between floating point representation and FracXX constant.
#define  CFF16(X) (Frac16)(X*32768.0)
#define  CFF32(X) (Frac32)(X*2147483648.0)
#define ICFF16(X) (((double)(X))/32768.0)
#define ICFF32(X) (((double)(X))/2147483648.0)

/* limit definitions */
#define MAX_16              (Frac16)0x7FFF
#define MIN_16              (Frac16)0x8000

#define MAX_32              (Frac32)0x7FFFFFFFL
#define MIN_32              (Frac32)0x80000000L

/* useful macros */
#define FRAC16(x) ((Frac16)((x) < 1 ? ((x) >= -1 ? CFF16(x) : MIN_16) : MAX_16))
#define FRAC32(x) ((Frac32)((x) < 1 ? ((x) >= -1 ? CFF32(x) : MIN_32) : MAX_32))



#endif //__FIR_H
